<?php
// Koneksi ke database
$mysqli = new mysqli("localhost", "root", "", "persewaan_db");

if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Ambil data profil dari database (misalnya, ada tabel `profil_usaha`)
$stmt = $mysqli->prepare("SELECT * FROM profil_usaha WHERE id = 1");  // Anggap hanya ada satu data profil
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

$stmt->close();
$mysqli->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profil Usaha</title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <header>
        <div class="container">
            <h1>Profil Usaha Persewaan Kendaraan</h1>
            <nav>
                <a href="index.php">Beranda</a>
                <a href="create.php">Tambah Data</a>
                <a href="profile.php">Profil Usaha</a>
            </nav>
        </div>
    </header>

    <main>
        <div class="profil-container">
            <h2>Informasi Profil Usaha</h2>
            <?php if ($data): ?>
                <div class="profil-detail">
                    <p><strong>Nama Usaha:</strong> <?= htmlspecialchars($data['nama_usaha']); ?></p>
                    <p><strong>Alamat:</strong> <?= htmlspecialchars($data['alamat']); ?></p>
                    <p><strong>Kontak:</strong> <?= htmlspecialchars($data['kontak']); ?></p>
                    <p><strong>Deskripsi:</strong> <?= nl2br(htmlspecialchars($data['deskripsi'])); ?></p>
                    <p><strong>Jam Operasional:</strong> <?= htmlspecialchars($data['jam_operasional']); ?></p>
                </div>
            <?php else: ?>
                <p>Profil usaha tidak ditemukan.</p>
            <?php endif; ?>
        </div>
    </main>
</body>
</html>
